/*
 * Base class for the different views.
 *
 * Copyright(C) 2001 Emmanuel VARAGNAT <coredump@free.fr>
 * licensed under the GPL
 */
                                                                                                                                        
#ifndef __IDELOAD_H__
#define __IDELOAD_H__

#include <X11/X.h>
#include <X11/Xlib.h>
#include <assert.h>
#include <string>

class BadColorName {
 public:
  string msg;
  BadColorName(const string &str) : msg(str) {}
};

class PixBuff {
 public:
  Pixmap        pix;
  unsigned int  width, height;

 protected:
  Display       *dpy;
  Window        win;
  XColor        white, black, fg, bg;
  GC            gc_white, gc_black, gc_fg, gc_bg;

 public:
  PixBuff(Display *disp, Window window,
	  unsigned int w, unsigned int h,
	  char *fg_str = NULL, char *bg_str = NULL)
  {
    XColor unused;
    XGCValues gcv;

    assert(disp != NULL);
    dpy = disp;
    win = window;
    width = w;
    height = h;

    /* Create black and white GC */
    white.pixel = WhitePixel(dpy, DefaultScreen(dpy));
    black.pixel = BlackPixel(dpy, DefaultScreen(dpy));

    gcv.foreground = white.pixel;
    gc_white = XCreateGC(dpy, win,
			 GCForeground,
			 &gcv);
    gcv.foreground = black.pixel;
    gc_black = XCreateGC(dpy, win,
			 GCForeground,
			 &gcv);

    if(fg_str) {
      if(XAllocNamedColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)),
			  fg_str, &fg, &unused) == 0)
	{
	  throw BadColorName("foreground");
	}
      gcv.foreground = fg.pixel;
      gc_fg = XCreateGC(dpy, win,
			GCForeground,
			&gcv);
    }
    else
      gc_fg = gc_black;

    if(bg_str) {
      if(XAllocNamedColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)),
			  bg_str, &bg, &unused) == 0)
	{
	  throw BadColorName("background");
	}
      gcv.foreground = bg.pixel;
      gc_bg = XCreateGC(dpy, win,
			GCForeground,
			&gcv);
    }
    else
      gc_bg = gc_white;

    pix = XCreatePixmap(dpy, win, w, h, DefaultDepth(dpy, DefaultScreen(dpy)));
  }

  virtual void resize(unsigned int w, unsigned int h) {
    width = w;
    height = h;
    XFreePixmap(dpy, pix);
    pix = XCreatePixmap(dpy, win,
			w, h,
			DefaultDepth(dpy, DefaultScreen(dpy)));
  }

  virtual void update() = 0;
  virtual void draw() = 0;
};

#endif
