/*
 * Header for circular buffers.
 *
 * Copyright(C) 2001 Emmanuel VARAGNAT <coredump@free.fr>
 * licensed under the GPL
 */

#ifndef __CIRC_BUFF_H__
#define __CIRC_BUFF_H__

struct circ_buff {        /* circular buffer */
  unsigned int  *buff;
  unsigned int  len;      /* buffer length */
  unsigned int  *begin;
  unsigned int  *end;
  unsigned int  window;
  unsigned int  full; 
  
};

int cbuff_init(struct circ_buff *buff, unsigned int win);
int cbuff_resize(struct circ_buff *buff, unsigned int new_win);


static inline unsigned int cbuff_get(struct circ_buff *buff, unsigned int i) {
  return buff->buff[(buff->begin - buff->buff + i) % buff->window];
}

static inline void cbuff_add(struct circ_buff *buff, unsigned int val) {
  *(buff->end) = val;

  buff->end = (buff->end+1 >= buff->buff + buff->window) ? buff->buff : buff->end+1;

  buff->full = (buff->full || buff->end == buff->begin);

  buff->begin = (buff->full) ? buff->end : buff->begin;
}

static inline unsigned int cbuff_real_size(struct circ_buff *buff) {
  if(buff->full)
    return buff->window;

  if(buff->end < buff->begin)
    return buff->window - (buff->begin - buff->end);
  else
    return buff->end - buff->begin;
}

#endif
