/*
 * Class definition of the IRQ activity view of one IDE controler.
 *
 * Copyright(C) 2001 Emmanuel VARAGNAT <coredump@free.fr>
 * licensed under the GPL
 */

#ifndef __IRQACT_H__
#define __IRQACT_H__

#include "circ_buff.h"
#include "ide_load.h"

class IrqAct : public PixBuff {
 private:
  unsigned int         irq;
  struct circ_buff     buff;
  unsigned long long   last;
  unsigned long long   max;
  char                 *name;

  GC                   gc_graph;
  XFontStruct          *fst;

 public:
  IrqAct(Display *dpy, Window win,
	 unsigned int w, unsigned int h,
	 unsigned int interrupt, char *ide_name,
	 unsigned int size = 100,
	 char *fg_str = NULL, char *bg_str = NULL,
	 char *graph = NULL);
  void draw();
  void resize(unsigned int w, unsigned int h);
  void update();

 private:  
  int get_val(unsigned long long *val);
};

#endif
