/*
 * Class definition of the R/W IO activity view.
 *
 * Copyright(C) 2001 Emmanuel VARAGNAT <coredump@free.fr>
 * licensed under the GPL
 */

#ifndef __IOACT1_H__
#define __IOACT1_H__

#include "circ_buff.h"
#include "ide_load.h"

class IOAct1 : public PixBuff {
 private:
  struct circ_buff    rio;
  struct circ_buff    io;

  unsigned long long  lastread, lasttot;
  unsigned long long  max;

  GC                  gc_rd, gc_wr;
  XFontStruct         *fst;

 public:
  IOAct1(Display *dpy, Window win,
	 unsigned int w, unsigned int h,
	 unsigned int size = 100,
	 char *fg_str = NULL, char *bg_str = NULL,
	 char *rd_str = NULL, char *wr_str = NULL);
  void draw();
  void resize(unsigned int w, unsigned int h);
  void update();

 private:  
  void get_val(unsigned long *rio, unsigned long *wio);
};

#endif
